/*
 * @brief LPC15xx WS2811 LED driver
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licenser disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#ifndef __SCT1_WS2811_H_
#define __SCT1_WS2811_H_

#include "board.h"

#define DATA_OUT          0                               // use SCT1_OUT0 as data output
#define AUX_OUT           1                               // use SCT1_OUT1 as aux output
#define DATA_SPEED        800000

#define WS2811_FB         (SystemCoreClock/DATA_SPEED)    // full data bit time   = 90 (at 800 kb/s)
#define WS2811_T0H        ((WS2811_FB*20)/100)            // data bit 0 high time = 18 (at 800 kb/s)
#define WS2811_T1H        ((WS2811_FB*48)/100)            // data bit 1 high time ~ 43 (at 800 kb/s)

#ifdef __cplusplus
extern "C" {
#endif

void LEDDRIVER_open(void);
void LEDDRIVER_write(uint32_t rgb);                // write frame
void LEDDRIVER_haltAfterFrame(int on);             // (de)activate HALT after next frame
void LEDDRIVER_start(void);                        // start a transmission

#ifdef __cplusplus
}
#endif

#endif /* __SCT1_WS2811_H_ */
